/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.spawn;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import techguns.entities.npc.GenericNPC;
import techguns.entities.spawn.TGNpcSpawn;
import techguns.util.MathUtil;

public class TGSpawnManager {
    public static ArrayList<TGNpcSpawn> NPCs_lvl0 = new ArrayList();
    public static ArrayList<TGNpcSpawn> NPCs_lvl1 = new ArrayList();
    public static ArrayList<TGNpcSpawn> NPCs_lvl2 = new ArrayList();
    public static ArrayList<TGNpcSpawn> NPCs_lvl3 = new ArrayList();
    public static ArrayList<TGNpcSpawn> NPCs_lvl4 = new ArrayList();
    public static ArrayList<TGNpcSpawn> NPCs_lvl5 = new ArrayList();
    public static ArrayList<ArrayList<TGNpcSpawn>> spawntable = new ArrayList(6);
    private static Random rnd = new Random();
    private static BiomeGenBase[] overworldLandBiomes;
    private static BiomeGenBase[] desertBiomes;
    private static BiomeGenBase[] iceBiomes;

    public static void registerSpawn(TGNpcSpawn spawn, int danger) {
        ArrayList<TGNpcSpawn> list = spawntable.get(danger);
        if (list != null) {
            list.add(spawn);
        } else {
            System.out.println("Tried to register NPC spawn for dangerlevel outside of [0-5]: " + danger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSpawn(World w, Entity dummyEnt) {
        GenericNPC entNew = null;
        BiomeGenBase biome = w.func_72807_a((int)Math.round(dummyEnt.field_70165_t), (int)Math.round(dummyEnt.field_70161_v));
        int dist_danger = TGSpawnManager.getDistanceDanger(w, dummyEnt);
        int biome_danger = TGSpawnManager.getBiomeDanger(w, dummyEnt, biome);
        int danger = dist_danger + biome_danger;
        TGNpcSpawn chosenSpawn = null;
        int totalweight = 0;
        for (int d = 0; d <= danger; ++d) {
            ArrayList<TGNpcSpawn> list = spawntable.get(d);
            for (int i = 0; i < list.size(); ++i) {
                TGNpcSpawn spawn = list.get(i);
                if (!spawn.dimensionMatches(w)) continue;
                totalweight += spawn.getWeightForBiome(biome);
            }
        }
        if (totalweight > 0) {
            int roll = rnd.nextInt(totalweight);
            totalweight = 0;
            for (int d = 0; d <= danger; ++d) {
                ArrayList<TGNpcSpawn> list = spawntable.get(d);
                for (int i = 0; i < list.size(); ++i) {
                    TGNpcSpawn spawn = list.get(i);
                    if (!spawn.dimensionMatches(w) || (totalweight += spawn.getWeightForBiome(biome)) < roll) continue;
                    chosenSpawn = spawn;
                    break;
                }
                if (chosenSpawn != null) break;
            }
            if (chosenSpawn != null) {
                try {
                    entNew = chosenSpawn.type.getDeclaredConstructor(World.class).newInstance(w);
                    TGSpawnManager.setPositionsAndReplace(w, entNew, dummyEnt);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                finally {
                    dummyEnt.func_70106_y();
                }
            }
        } else {
            System.out.println("TotalWeight 0, nothing to spawn???");
        }
    }

    private static int getBiomeDanger(World w, Entity ent, BiomeGenBase biome) {
        if (biome.func_150561_m() == BiomeGenBase.TempCategory.COLD) {
            return 1;
        }
        if (biome.func_150561_m() == BiomeGenBase.TempCategory.WARM) {
            return 2;
        }
        return 0;
    }

    private static int getDistanceDanger(World w, Entity ent) {
        MathUtil.Vec2 spawn = new MathUtil.Vec2(w.func_72861_E().field_71574_a, w.func_72861_E().field_71573_c);
        MathUtil.Vec2 pos = new MathUtil.Vec2(ent.field_70165_t, ent.field_70161_v);
        double distance = spawn.getVecTo(pos).len();
        if (distance < 500.0) {
            return 0;
        }
        if (distance < 1000.0) {
            return 1;
        }
        if (distance < 2000.0) {
            return 2;
        }
        return 3;
    }

    public static boolean isInArray(BiomeGenBase biome, BiomeGenBase[] biomes) {
        for (int i = 0; i < biomes.length; ++i) {
            if (!biome.equals(biomes[i])) continue;
            return true;
        }
        return false;
    }

    private static void setPositionsAndReplace(World w, GenericNPC newNpc, Entity entity) {
        newNpc.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
        newNpc.func_110161_a(null);
        w.func_72838_d((Entity)newNpc);
        entity.func_70106_y();
    }

    static {
        spawntable.add(NPCs_lvl0);
        spawntable.add(NPCs_lvl1);
        spawntable.add(NPCs_lvl2);
        spawntable.add(NPCs_lvl3);
        spawntable.add(NPCs_lvl4);
        spawntable.add(NPCs_lvl5);
        overworldLandBiomes = new BiomeGenBase[]{BiomeGenBase.field_76787_r, BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q, BiomeGenBase.field_150577_O, BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v, BiomeGenBase.field_150580_W, BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76775_o, BiomeGenBase.field_76774_n, BiomeGenBase.field_76782_w, BiomeGenBase.field_150574_L, BiomeGenBase.field_76792_x, BiomeGenBase.field_150578_U, BiomeGenBase.field_150581_V, BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa, BiomeGenBase.field_76789_p, BiomeGenBase.field_76788_q, BiomeGenBase.field_76772_c, BiomeGenBase.field_76781_i, BiomeGenBase.field_150585_R, BiomeGenBase.field_150588_X, BiomeGenBase.field_150576_N, BiomeGenBase.field_76780_h, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u};
        desertBiomes = new BiomeGenBase[]{BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa};
        iceBiomes = new BiomeGenBase[]{BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76775_o, BiomeGenBase.field_76774_n, BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T, BiomeGenBase.field_150577_O};
    }
}

