/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.client.ClientProxy;
import techguns.client.GoreData;
import techguns.client.particle.EntityParticleAnimated;
import techguns.client.renderer.TGRenderHelper;

public class FlyingGibs
extends Entity {
    public int maxTimeToLive = 200;
    public int timeToLive = 200;
    public double gravity = 0.03f;
    public float size;
    public Vec3 rotationAxis;
    public int bodypart;
    public int hitGroundTTL = 0;
    public EntityLivingBase entity;
    public GoreData data;

    public FlyingGibs(World world, EntityLivingBase entity, GoreData data, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, float size, int bodypart) {
        super(world);
        this.func_70107_b(posX, posY, posZ);
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        this.size = size;
        this.timeToLive = this.maxTimeToLive = 150 + this.field_70146_Z.nextInt(101);
        this.entity = entity;
        this.bodypart = bodypart;
        this.rotationAxis = Vec3.func_72443_a((double)this.field_70146_Z.nextDouble(), (double)this.field_70146_Z.nextDouble(), (double)this.field_70146_Z.nextDouble());
        this.data = data;
    }

    public FlyingGibs(World world) {
        super(world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.timeToLive > 0) {
            --this.timeToLive;
        } else {
            this.func_70106_y();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= this.gravity;
        if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_85030_a("random.fizz", 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            if (this.hitGroundTTL == 0) {
                this.hitGroundTTL = this.timeToLive;
            }
            f = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= (double)-0.9f;
        } else if (this.data.showBlood) {
            EntityParticleAnimated fx = new EntityParticleAnimated(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, "blood4x4.png", 2, 2, 4, TGRenderHelper.RenderType.ALPHA);
            fx.field_70159_w = this.field_70159_w;
            fx.field_70181_x = this.field_70181_x;
            fx.field_70179_y = this.field_70179_y;
            fx.setGravity(0.07f);
            fx.setMaxAge(15);
            fx.setScaleIncrease(this.size * 2.0f, this.size * 4.0f, 1.0f, true);
            fx.setDynamicColor(this.data.bloodColorR, this.data.bloodColorG, this.data.bloodColorB, 255.0f, this.data.bloodColorR, this.data.bloodColorG, this.data.bloodColorB, 0.0f, EntityParticleAnimated.DynamicColorType.LINEAR);
            fx.setDynamicColorStart(0.5f);
            fx.setRandomRotation(true);
            fx.setRandomness(0.8f);
            fx.setMotionDamping(0.92);
            fx.setFramesAsVariations(true);
            ClientProxy.spawnParticle(fx);
        }
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }
}

