/*
 * Decompiled with CFR 0.152.
 */
package techguns.damagesystem;

import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.util.EnumHelper;
import techguns.damagesystem.DamageType;

public class TGArmorMaterial {
    public String name;
    private static final int VANILLA_DURABILITY_FACTOR_SUM = 55;
    protected float armorPhys = 0.0f;
    protected float armorProjectile = 0.0f;
    protected float armorExplosion = 0.0f;
    protected float armorEnergy = 0.0f;
    protected float armorFire = 0.0f;
    protected float armorLightning = 0.0f;
    protected float armorIce = 0.0f;
    protected float armorPoison = 0.0f;
    protected float armorRadiation = 0.0f;
    protected float penetrationResistance = 0.0f;
    protected float factorHead = 0.25f;
    protected float factorBoots = 0.2f;
    protected float factorLegs = 0.25f;
    protected float factorChest = 0.3f;
    protected float durHead = 0.25f;
    protected float durBoots = 0.25f;
    protected float durLegs = 0.25f;
    protected float durChest = 0.25f;
    protected int baseDur;
    protected int enchantability;

    public TGArmorMaterial(String name, int baseDurability, int enchantability, float phys, float proj, float fire, float exp, float energy, float poison, float ice, float light, float rad) {
        this.name = name;
        this.baseDur = baseDurability;
        this.enchantability = enchantability;
        this.armorPhys = phys;
        this.armorProjectile = proj;
        this.armorFire = fire;
        this.armorExplosion = exp;
        this.armorEnergy = energy;
        this.armorPoison = poison;
        this.armorIce = ice;
        this.armorLightning = light;
        this.armorRadiation = rad;
    }

    public TGArmorMaterial(String name, int baseDurability, int enchantability, float phys, float proj, float elemental) {
        this.name = name;
        this.baseDur = baseDurability;
        this.enchantability = enchantability;
        this.armorPhys = phys;
        this.armorProjectile = proj;
        this.armorFire = elemental;
        this.armorExplosion = elemental;
        this.armorEnergy = elemental;
        this.armorIce = elemental;
        this.armorLightning = elemental;
    }

    public TGArmorMaterial(String name, int baseDurability, int enchantability, float armor) {
        this.name = name;
        this.baseDur = baseDurability;
        this.enchantability = enchantability;
        float f = 0.75f;
        this.armorPhys = armor;
        this.armorProjectile = armor;
        this.armorFire = armor * f;
        this.armorExplosion = armor * f;
        this.armorEnergy = armor * f;
        this.armorIce = armor * f;
        this.armorLightning = armor * f;
        this.armorPoison = 0.0f;
        this.armorRadiation = 0.0f;
    }

    public TGArmorMaterial setPartArmorSplit(float helm, float chest, float legs, float boots) {
        this.factorHead = helm;
        this.factorChest = chest;
        this.factorLegs = legs;
        this.factorBoots = boots;
        return this;
    }

    public TGArmorMaterial setPartDurabilitySplit(float helm, float chest, float legs, float boots) {
        this.durHead = helm;
        this.durChest = chest;
        this.durLegs = legs;
        this.durBoots = boots;
        return this;
    }

    public TGArmorMaterial setPenetrationResistance(float penresist) {
        this.penetrationResistance = penresist;
        return this;
    }

    public float getArmorValueTotal(DamageType damageType) {
        switch (damageType) {
            case ENERGY: {
                return this.armorEnergy;
            }
            case EXPLOSION: {
                return this.armorExplosion;
            }
            case FIRE: {
                return this.armorFire;
            }
            case ICE: {
                return this.armorIce;
            }
            case LIGHTNING: {
                return this.armorLightning;
            }
            case PHYSICAL: {
                return this.armorPhys;
            }
            case POISON: {
                return this.armorPoison;
            }
            case PROJECTILE: {
                return this.armorProjectile;
            }
            case RADIATION: {
                return this.armorRadiation;
            }
        }
        return 0.0f;
    }

    public float getArmorValueSlot(int slot, DamageType type) {
        float materialArmor = this.getArmorValueTotal(type);
        switch (slot) {
            case 0: {
                return this.factorHead * materialArmor;
            }
            case 1: {
                return this.factorChest * materialArmor;
            }
            case 2: {
                return this.factorLegs * materialArmor;
            }
            case 3: {
                return this.factorBoots * materialArmor;
            }
        }
        return 0.0f;
    }

    public float getArmor(ItemArmor armor, DamageType type) {
        return this.getArmorValueSlot(armor.field_77881_a, type);
    }

    public ItemArmor.ArmorMaterial createVanillaMaterial() {
        int[] av = new int[]{Math.round(this.getArmorValueSlot(0, DamageType.PHYSICAL)), Math.round(this.getArmorValueSlot(1, DamageType.PHYSICAL)), Math.round(this.getArmorValueSlot(2, DamageType.PHYSICAL)), Math.round(this.getArmorValueSlot(3, DamageType.PHYSICAL))};
        return EnumHelper.addArmorMaterial((String)this.name, (int)this.baseDur, (int[])av, (int)this.enchantability);
    }

    public TGArmorMaterial setArmorProjectile(float armorProjectile) {
        this.armorProjectile = armorProjectile;
        return this;
    }

    public TGArmorMaterial setArmorExplosion(float armorExplosion) {
        this.armorExplosion = armorExplosion;
        return this;
    }

    public TGArmorMaterial setArmorEnergy(float armorEnergy) {
        this.armorEnergy = armorEnergy;
        return this;
    }

    public TGArmorMaterial setArmorFire(float armorFire) {
        this.armorFire = armorFire;
        return this;
    }

    public TGArmorMaterial setArmorLightning(float armorLightning) {
        this.armorLightning = armorLightning;
        return this;
    }

    public TGArmorMaterial setArmorIce(float armorIce) {
        this.armorIce = armorIce;
        return this;
    }

    public TGArmorMaterial setArmorPoison(float armorPoison) {
        this.armorPoison = armorPoison;
        return this;
    }

    public TGArmorMaterial setArmorRadiation(float armorRadiation) {
        this.armorRadiation = armorRadiation;
        return this;
    }

    public TGArmorMaterial setArmorPhys(float armorPhys) {
        this.armorPhys = armorPhys;
        return this;
    }

    public int getDurability(int slot) {
        switch (slot) {
            case 0: {
                return Math.round(this.durHead * 55.0f * (float)this.baseDur);
            }
            case 1: {
                return Math.round(this.durChest * 55.0f * (float)this.baseDur);
            }
            case 2: {
                return Math.round(this.durLegs * 55.0f * (float)this.baseDur);
            }
            case 3: {
                return Math.round(this.durBoots * 55.0f * (float)this.baseDur);
            }
        }
        return 0;
    }

    public float getPenetrationResistance() {
        return this.penetrationResistance;
    }
}

