/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import techguns.client.renderer.TGRenderHelper;
import techguns.client.renderer.block.TessellatorCubeProper;
import techguns.inventory.ReactionBeamFocus;
import techguns.tileentities.ReactionChamberTileEntMaster;
import techguns.util.BlockCoords;

public class RenderReactionChamber
extends TileEntitySpecialRenderer {
    private ResourceLocation mainTexture;
    private ResourceLocation glassTexture = new ResourceLocation("techguns", "textures/entity/reactionchamberglass.png");
    private ResourceLocation heatrayTexture = new ResourceLocation("techguns", "textures/fx/heatray.png");
    private IModelCustom mainModel;
    private EntityItem entItem = null;
    private TessellatorCubeProper liquidCube = new TessellatorCubeProper(Blocks.field_150346_d, 0);

    public RenderReactionChamber(String model, String texture) {
        this.mainTexture = new ResourceLocation("techguns", texture);
        this.mainModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("techguns", model));
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float ptt) {
        ReactionChamberTileEntMaster tile = (ReactionChamberTileEntMaster)te;
        if (tile.isComplete()) {
            double scale = 0.03125;
            GL11.glPushMatrix();
            TGRenderHelper.adjustLightFixture(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145838_q());
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            float rot = -180.0f;
            switch (tile.dir) {
                case 3: {
                    rot = 0.0f;
                    break;
                }
                case 4: {
                    rot = -90.0f;
                    break;
                }
                case 5: {
                    rot = 90.0f;
                }
            }
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
            ItemStack itemStack = null;
            itemStack = tile.isWorking() ? tile.currentOperation : tile.func_70301_a(0);
            if (itemStack != null) {
                if (this.entItem == null || this.entItem.func_92059_d() != itemStack) {
                    this.entItem = new EntityItem(tile.func_145831_w(), x, y, z, itemStack);
                }
                this.entItem.field_70290_d = 0.0f;
                RenderManager.field_78727_a.func_147940_a((Entity)this.entItem, 0.0, 1.5, 0.0, 0.0f, 0.0f);
            }
            GL11.glPushMatrix();
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            this.func_147499_a(this.mainTexture);
            this.mainModel.renderAllExcept(new String[]{"GLASS"});
            GL11.glPopMatrix();
            GL11.glRotatef((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
            Tessellator tess = Tessellator.field_78398_a;
            GL11.glDepthMask((boolean)false);
            if (tile.isWorking() && (itemStack = tile.func_70301_a(1)) != null) {
                ReactionBeamFocus focus = ReactionBeamFocus.getBeamFocus(itemStack);
                this.renderBeamFocusEffect(focus, tile, tess, ptt);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            FluidStack liquid = tile.inputTank.getFluid();
            if (liquid != null) {
                this.func_147499_a(TextureMap.field_110575_b);
                tess.func_78382_b();
                double w = 0.9375;
                double h1 = 0.5;
                double h2 = 2.9375;
                double level = (double)tile.inputTank.getFluidAmount() / (double)tile.inputTank.getCapacity();
                TGRenderHelper.enableAlphaBlend();
                IIcon tex = tile.isWorking() ? liquid.getFluid().getFlowingIcon() : liquid.getFluid().getIcon();
                this.liquidCube.drawStandardCube(tess, -w, h1, -w, w, h2 * level + 0.5, w, true, tex);
                tess.func_78381_a();
                TGRenderHelper.disableAlphaBlend();
            }
            GL11.glPushMatrix();
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            this.func_147499_a(this.glassTexture);
            this.mainModel.renderPart("GLASS");
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    private void renderBeamFocusEffect(ReactionBeamFocus focus, ReactionChamberTileEntMaster tile, Tessellator tess, float ptt) {
        GL11.glPushMatrix();
        TGRenderHelper.enableAlphaBlendAdditive();
        TGRenderHelper.enableFXLighting();
        GL11.glDisable((int)2884);
        this.func_147499_a(this.heatrayTexture);
        double d = ((double)(tile.currentReaction.duration % 10) + (double)ptt) / 10.0;
        d = 0.875 + 0.125 * (1.0 - Math.cos(Math.PI * d * 2.0));
        double w = 0.9375 * d;
        double h1 = 0.5;
        double h2 = 2.9375;
        float b = (float)tile.intensity / 10.0f * (float)d - 0.25f;
        double x1 = Minecraft.func_71410_x().field_71439_g.field_70165_t;
        double z1 = Minecraft.func_71410_x().field_71439_g.field_70161_v;
        BlockCoords bc = tile.getCenterPos();
        double angle = Math.atan2((double)bc.z + 0.5 - z1, (double)bc.x + 0.5 - x1) * 180.0 / Math.PI;
        GL11.glRotated((double)(-angle + 90.0), (double)0.0, (double)1.0, (double)0.0);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, b);
        tess.func_78382_b();
        tess.func_78374_a(-w, h1, 0.0, 0.0, 1.0);
        tess.func_78374_a(-w, h2, 0.0, 0.0, 0.0);
        tess.func_78374_a(w, h2, 0.0, 1.0, 0.0);
        tess.func_78374_a(w, h1, 0.0, 1.0, 1.0);
        tess.func_78381_a();
        GL11.glEnable((int)2884);
        TGRenderHelper.disableFXLighting();
        TGRenderHelper.disableAlphaBlend();
        GL11.glPopMatrix();
    }
}

