/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import techguns.client.ClientProxy;
import techguns.client.models.ModelGunAmmo;
import techguns.client.renderer.item.RenderGun;
import techguns.items.armors.ICamoChangeable;
import techguns.items.guns.GenericGun;

public abstract class RenderGunScoped
extends RenderGun {
    public RenderGunScoped(ModelBase model, ResourceLocation texture, float scale, float x, float y, float z, boolean handleDamageValue, boolean handleProgress) {
        super(model, texture, scale, x, y, z, handleDamageValue, handleProgress);
    }

    public RenderGunScoped(ModelBase model, ResourceLocation texture, float scale, float x, float y, float z) {
        super(model, texture, scale, x, y, z);
    }

    private boolean isZooming() {
        return ClientProxy.get().player_zoom != 1.0f;
    }

    public abstract void renderScope();

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        boolean showMuzzleFX = false;
        float muzzleFXprogress = 0.0f;
        boolean renderScope = false;
        ClientProxy cp = ClientProxy.get();
        GL11.glPushMatrix();
        float reloadProgress = 10.0f;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            float prog = 0.0f;
            if (this.handleProgress) {
                int maxdur;
                int dur = Minecraft.func_71410_x().field_71439_g.func_71057_bx();
                prog = (float)dur / ((float)(maxdur = 20) * 1.0f);
                if (prog < 0.0f) {
                    prog = 0.0f;
                } else if (prog > 1.0f) {
                    prog = 1.0f;
                }
            }
            this.GL_Transform_FirstPerson(prog);
            if (cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L) {
                long diff = cp.getplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis();
                if (diff <= 0L) {
                    cp.setplayerReloadtime((EntityLivingBase)ClientProxy.get().getPlayerClient(), 0L, 0, (byte)0);
                    this.GL_Transform_reload_done();
                } else {
                    long reloadtimeTotal = cp.getplayerReloadtimeTotal();
                    reloadProgress = 1.0f - (float)diff / (float)reloadtimeTotal;
                    this.GL_Transform_reloading(reloadProgress);
                }
            } else if (cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) > 0L) {
                if (!this.isZooming()) {
                    long diff = cp.getplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient()) - System.currentTimeMillis();
                    if (diff <= 0L || diff > cp.getplayerRecoiltimeTotal()) {
                        cp.setplayerRecoiltime((EntityLivingBase)ClientProxy.get().getPlayerClient(), 0L, 0, (byte)0);
                        this.GL_Transform_Translate();
                    } else {
                        float fireProgress = 1.0f - (float)diff / (float)cp.getplayerRecoiltimeTotal();
                        this.GL_Transform_firing(fireProgress);
                    }
                } else {
                    renderScope = true;
                }
            } else if (!this.isZooming()) {
                this.GL_Transform_Translate();
                showMuzzleFX = false;
            } else {
                renderScope = true;
            }
            if (cp.player_muzzleFlashtime > 0L) {
                long diff = cp.player_muzzleFlashtime - System.currentTimeMillis();
                if (diff <= 0L || diff > cp.player_muzzleFlashtime_total) {
                    cp.player_muzzleFlashtime = 0L;
                    cp.player_muzzleFlashtime_total = 0L;
                } else {
                    showMuzzleFX = !this.isZooming();
                    muzzleFXprogress = 1.0f - (float)diff / (float)cp.player_muzzleFlashtime_total;
                }
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            this.GL_Transform_Equipped();
            EntityLivingBase shooter = (EntityLivingBase)data[1];
            if (cp.getplayerRecoiltime(shooter) > 0L) {
                long diff = cp.getplayerRecoiltime(shooter) - System.currentTimeMillis();
                if (diff <= 0L || diff > cp.getplayerRecoiltimeTotal(shooter)) {
                    cp.setplayerRecoiltime(shooter, 0L, 0, (byte)0);
                } else {
                    float fireProgress = 1.0f - (float)diff / (float)cp.getplayerRecoiltimeTotal(shooter);
                    this.GL_TransformRecoil_Equipped(fireProgress);
                }
            }
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.GL_Transform_Ground();
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.GL_Transform_Icon();
        }
        if (!renderScope) {
            int camo = 0;
            if (item.func_77973_b() instanceof ICamoChangeable) {
                ICamoChangeable camoitem = (ICamoChangeable)item.func_77973_b();
                camo = (byte)camoitem.getCurrentCamoIndex(item);
            }
            ResourceLocation tex = ((GenericGun)item.func_77973_b()).textures.get(camo);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
            if (this.handleDamageValue) {
                ((ModelGunAmmo)this.model).render(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, item.func_77958_k() - item.func_77960_j(), reloadProgress, type);
            } else {
                this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glPopMatrix();
        } else {
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderScope();
            GL11.glPopMatrix();
        }
        if (showMuzzleFX) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.5f, (float)-1.0f, (float)-0.5f);
            this.drawMuzzleFX(muzzleFXprogress);
            GL11.glPopMatrix();
        }
    }
}

