/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines;

import com.cricketcraft.chisel.api.ICarvable;
import com.cricketcraft.chisel.api.carving.CarvableHelper;
import com.cricketcraft.chisel.api.carving.IVariationInfo;
import com.cricketcraft.chisel.api.rendering.ClientUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import techguns.TGBlocks;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.packets.PacketTGMessage;
import techguns.tileentities.BasicPoweredTileEnt;
import techguns.tileentities.FabricatorTileEntMaster;
import techguns.tileentities.FabricatorTileEntSlave;
import techguns.tileentities.MultiBlockMasterTileEntBase;
import techguns.tileentities.MultiBlockSlaveTileEntBase;
import techguns.tileentities.ReactionChamberTileEntMaster;
import techguns.tileentities.ReactionChamberTileEntSlave;
import techguns.util.BlockCoords;
import techguns.util.TextUtil;

public class MultiBlockMachineBlock
extends BlockContainer
implements ICarvable {
    public CarvableHelper carverHelper = new CarvableHelper((Block)this);
    private static byte META_INVISIBLE = (byte)15;
    private static byte MAX_META = (byte)5;

    public MultiBlockMachineBlock() {
        super(Material.field_151573_f);
        this.func_149663_c("machineMultiBlock");
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(Techguns.tabTechgun);
        this.func_149711_c(8.0f);
        this.func_149752_b(50.0f);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149651_a(IIconRegister register) {
        this.carverHelper.registerBlockIcons("Techguns", (Block)this, register);
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        for (IVariationInfo info : this.carverHelper.infoList) {
            if (info.getVariation().getBlockMeta() > MAX_META) continue;
            list.add(new ItemStack((Block)this, 1, info.getVariation().getItemMeta()));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == 0 || meta == 2) {
            return new ReactionChamberTileEntSlave();
        }
        if (meta == 1) {
            return new ReactionChamberTileEntMaster();
        }
        if (meta == 3 || meta == 5) {
            return new FabricatorTileEntSlave();
        }
        if (meta == 4) {
            return new FabricatorTileEntMaster();
        }
        return null;
    }

    public int func_149645_b() {
        return ClientUtils.renderCTMId;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase ent, ItemStack item) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 1 || meta == 4) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (ent instanceof EntityPlayer && tile instanceof BasicPoweredTileEnt) {
                ((BasicPoweredTileEnt)tile).setOwner((EntityPlayer)ent);
            }
        }
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof MultiBlockSlaveTileEntBase) {
                MultiBlockSlaveTileEntBase slave = (MultiBlockSlaveTileEntBase)tile;
                slave.notifyMasterMultiblockBreak();
            }
            if (tile instanceof MultiBlockMasterTileEntBase) {
                MultiBlockMasterTileEntBase master = (MultiBlockMasterTileEntBase)tile;
                master.notifiyMultiblockBreak();
                master.onBlockBreak();
            }
            world.func_147475_p(x, y, z);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int sideHit, float f1, float f2, float f3) {
        TileEntity tile = world.func_147438_o(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 2) {
            if (tile instanceof ReactionChamberTileEntSlave) {
                ReactionChamberTileEntSlave slave = (ReactionChamberTileEntSlave)tile;
                if (slave.hasMaster()) {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() == Techguns.blockReaderTool) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Master:" + slave.hasMaster()));
                        player.func_145747_a((IChatComponent)new ChatComponentText("Pos:" + slave.getMasterPos()[0] + "," + slave.getMasterPos()[1] + "," + slave.getMasterPos()[2]));
                        player.func_145747_a((IChatComponent)new ChatComponentText("Type:" + slave.getType()));
                    } else {
                        int[] masterpos = slave.getMasterPos();
                        TileEntity mt = world.func_147438_o(masterpos[0], masterpos[1], masterpos[2]);
                        if (mt != null && mt instanceof BasicPoweredTileEnt) {
                            if (((BasicPoweredTileEnt)mt).func_70300_a(player)) {
                                player.openGui((Object)"Techguns", 18, world, masterpos[0], masterpos[1], masterpos[2]);
                                return true;
                            }
                            if (player.field_70170_p.field_72995_K) {
                                player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.container.security.denied")));
                            }
                            return true;
                        }
                    }
                    return true;
                }
                return false;
            }
        } else if (meta == 1) {
            if (tile instanceof ReactionChamberTileEntMaster) {
                ReactionChamberTileEntMaster master = (ReactionChamberTileEntMaster)tile;
                if (master.isComplete()) {
                    ItemStack stack = player.func_71045_bC();
                    if (stack == null || stack.func_77973_b() != Techguns.blockReaderTool) {
                        if (master.func_70300_a(player)) {
                            player.openGui((Object)"Techguns", 18, world, x, y, z);
                            return true;
                        }
                        if (player.field_70170_p.field_72995_K) {
                            player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.container.security.denied")));
                        }
                        return true;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText("Complete:" + master.isComplete()));
                    player.func_145747_a((IChatComponent)new ChatComponentText("Direction:" + master.dir));
                    player.func_145747_a((IChatComponent)new ChatComponentText("Pos:" + master.field_145851_c + "," + master.field_145848_d + "," + master.field_145849_e));
                    return true;
                }
                BlockCoords pos = new BlockCoords(x, y, z);
                return this.CheckFormReactionChamber(player, pos, sideHit, world, master);
            }
        } else if (meta == 4) {
            if (tile instanceof FabricatorTileEntMaster) {
                FabricatorTileEntMaster master = (FabricatorTileEntMaster)tile;
                if (master.isComplete()) {
                    player.openGui((Object)"Techguns", 19, world, x, y, z);
                    return true;
                }
                BlockCoords pos = new BlockCoords(x, y, z);
                return this.CheckFormFabricator(player, pos, sideHit, world, master);
            }
        } else if ((meta == 3 || meta == 5) && tile instanceof FabricatorTileEntSlave) {
            FabricatorTileEntSlave slave = (FabricatorTileEntSlave)tile;
            if (slave.hasMaster()) {
                int[] masterpos = slave.getMasterPos();
                player.openGui((Object)"Techguns", 19, world, masterpos[0], masterpos[1], masterpos[2]);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean CheckFormReactionChamber(EntityPlayer player, BlockCoords masterPos, int direction, World w, ReactionChamberTileEntMaster master) {
        ArrayList<BlockCoords> top;
        ArrayList<BlockCoords> positions_block = null;
        ArrayList<BlockCoords> positions_glass = null;
        if (direction == 2) {
            positions_block = masterPos.getBoxWithOffsets(-1, 1, 0, 0, 0, 2, false);
            top = masterPos.getBoxWithOffsets(-1, 1, 3, 3, 0, 2, false);
            positions_block.addAll(top);
            positions_glass = masterPos.getBoxWithOffsets(-1, 1, 1, 2, 0, 2, false);
        } else if (direction == 3) {
            positions_block = masterPos.getBoxWithOffsets(-1, 1, 0, 0, -2, 0, false);
            top = masterPos.getBoxWithOffsets(-1, 1, 3, 3, -2, 0, false);
            positions_block.addAll(top);
            positions_glass = masterPos.getBoxWithOffsets(-1, 1, 1, 2, -2, 0, false);
        } else if (direction == 4) {
            positions_block = masterPos.getBoxWithOffsets(0, 2, 0, 0, -1, 1, false);
            top = masterPos.getBoxWithOffsets(0, 2, 3, 3, -1, 1, false);
            positions_block.addAll(top);
            positions_glass = masterPos.getBoxWithOffsets(0, 2, 1, 2, -1, 1, false);
        } else if (direction == 5) {
            positions_block = masterPos.getBoxWithOffsets(-2, 0, 0, 0, -1, 1, false);
            top = masterPos.getBoxWithOffsets(-2, 0, 3, 3, -1, 1, false);
            positions_block.addAll(top);
            positions_glass = masterPos.getBoxWithOffsets(-2, 0, 1, 2, -1, 1, false);
        }
        boolean valid = false;
        if (positions_block != null) {
            ReactionChamberTileEntSlave tile;
            int meta;
            Block b;
            BlockCoords pos;
            int i;
            valid = true;
            for (i = 0; i < positions_block.size(); ++i) {
                pos = positions_block.get(i);
                b = w.func_147439_a(pos.x, pos.y, pos.z);
                meta = w.func_72805_g(pos.x, pos.y, pos.z);
                if (b != TGBlocks.machineMultiBlock || meta != 0) {
                    if (!w.field_72995_K) {
                        TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                    }
                    valid = false;
                    break;
                }
                tile = (ReactionChamberTileEntSlave)w.func_147438_o(pos.x, pos.y, pos.z);
                if (!tile.hasMaster()) continue;
                if (!w.field_72995_K) {
                    TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                }
                valid = false;
                break;
            }
            if (valid) {
                for (i = 0; i < positions_glass.size(); ++i) {
                    pos = (BlockCoords)positions_glass.get(i);
                    b = w.func_147439_a(pos.x, pos.y, pos.z);
                    meta = w.func_72805_g(pos.x, pos.y, pos.z);
                    if (b != TGBlocks.machineMultiBlock || meta != 2) {
                        if (!w.field_72995_K) {
                            TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                        }
                        valid = false;
                        break;
                    }
                    tile = (ReactionChamberTileEntSlave)w.func_147438_o(pos.x, pos.y, pos.z);
                    if (!tile.hasMaster()) continue;
                    if (!w.field_72995_K) {
                        TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                    }
                    valid = false;
                    break;
                }
            }
            if (valid) {
                ArrayList<BlockCoords> inputsBottom = new ArrayList<BlockCoords>();
                BlockCoords middle = masterPos.getShifted(ForgeDirection.getOrientation((int)direction).getOpposite(), 1);
                BlockCoords inputTop = middle.getShifted(ForgeDirection.UP, 3);
                if (direction == 2) {
                    inputsBottom.add(middle.getShifted(ForgeDirection.SOUTH, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.EAST, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.WEST, 1));
                } else if (direction == 3) {
                    inputsBottom.add(middle.getShifted(ForgeDirection.NORTH, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.EAST, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.WEST, 1));
                } else if (direction == 4) {
                    inputsBottom.add(middle.getShifted(ForgeDirection.SOUTH, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.EAST, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.NORTH, 1));
                } else if (direction == 5) {
                    inputsBottom.add(middle.getShifted(ForgeDirection.SOUTH, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.WEST, 1));
                    inputsBottom.add(middle.getShifted(ForgeDirection.NORTH, 1));
                }
                positions_block.addAll(positions_glass);
                for (int i2 = 0; i2 < positions_block.size(); ++i2) {
                    BlockCoords pos2 = positions_block.get(i2);
                    TileEntity tile2 = w.func_147438_o(pos2.x, pos2.y, pos2.z);
                    if (tile2 != null && tile2 instanceof ReactionChamberTileEntSlave) {
                        ReactionChamberTileEntSlave slave = (ReactionChamberTileEntSlave)tile2;
                        slave.updateMaster(masterPos.x, masterPos.y, masterPos.z);
                        if (pos2.equals(inputTop)) {
                            slave.setType((byte)2);
                        } else if (inputsBottom.contains(pos2)) {
                            slave.setType((byte)1);
                        }
                        slave.needUpdate();
                        continue;
                    }
                    System.out.println("TileEnt null or wrong type, this should not happen!");
                }
                master.setComplete(true, (byte)direction);
                master.needUpdate();
                return true;
            }
        }
        return false;
    }

    private boolean CheckFormFabricator(EntityPlayer player, BlockCoords masterPos, int direction, World w, FabricatorTileEntMaster master) {
        ArrayList<BlockCoords> positions_block = null;
        ArrayList<BlockCoords> positions_glass = null;
        if (direction == 2) {
            positions_block = masterPos.getBoxWithOffsets(0, 1, 0, 0, 0, 1, false);
            positions_glass = masterPos.getBoxWithOffsets(0, 1, 1, 1, 0, 1, false);
        } else if (direction == 3) {
            positions_block = masterPos.getBoxWithOffsets(-1, 0, 0, 0, -1, 0, false);
            positions_glass = masterPos.getBoxWithOffsets(-1, 0, 1, 1, -1, 0, false);
        } else if (direction == 4) {
            positions_block = masterPos.getBoxWithOffsets(0, 1, 0, 0, -1, 0, false);
            positions_glass = masterPos.getBoxWithOffsets(0, 1, 1, 1, -1, 0, false);
        } else if (direction == 5) {
            positions_block = masterPos.getBoxWithOffsets(-1, 0, 0, 0, 0, 1, false);
            positions_glass = masterPos.getBoxWithOffsets(-1, 0, 1, 1, 0, 1, false);
        }
        boolean valid = false;
        if (positions_block != null) {
            FabricatorTileEntSlave tile;
            int meta;
            Block b;
            BlockCoords pos;
            int i;
            valid = true;
            for (i = 0; i < positions_block.size(); ++i) {
                pos = positions_block.get(i);
                b = w.func_147439_a(pos.x, pos.y, pos.z);
                meta = w.func_72805_g(pos.x, pos.y, pos.z);
                if (b != TGBlocks.machineMultiBlock || meta != 3) {
                    if (!w.field_72995_K) {
                        TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                    }
                    valid = false;
                    break;
                }
                tile = (FabricatorTileEntSlave)w.func_147438_o(pos.x, pos.y, pos.z);
                if (!tile.hasMaster()) continue;
                if (!w.field_72995_K) {
                    TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                }
                valid = false;
                break;
            }
            if (valid) {
                for (i = 0; i < positions_glass.size(); ++i) {
                    pos = positions_glass.get(i);
                    b = w.func_147439_a(pos.x, pos.y, pos.z);
                    meta = w.func_72805_g(pos.x, pos.y, pos.z);
                    if (b != TGBlocks.machineMultiBlock || meta != 5) {
                        if (!w.field_72995_K) {
                            TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                        }
                        valid = false;
                        break;
                    }
                    tile = (FabricatorTileEntSlave)w.func_147438_o(pos.x, pos.y, pos.z);
                    if (!tile.hasMaster()) continue;
                    if (!w.field_72995_K) {
                        TGPackets.network.sendTo((IMessage)new PacketTGMessage(0, pos.x, pos.y, pos.z), (EntityPlayerMP)player);
                    }
                    valid = false;
                    break;
                }
            }
            if (valid) {
                TileEntity tile2;
                for (i = 0; i < positions_block.size(); ++i) {
                    pos = positions_block.get(i);
                    tile2 = w.func_147438_o(pos.x, pos.y, pos.z);
                    if (tile2 != null && tile2 instanceof FabricatorTileEntSlave) {
                        FabricatorTileEntSlave slave = (FabricatorTileEntSlave)tile2;
                        slave.updateMaster(masterPos.x, masterPos.y, masterPos.z);
                        slave.setType((byte)1);
                        slave.needUpdate();
                        continue;
                    }
                    System.out.println("TileEnt null or wrong type, this should not happen!");
                }
                for (i = 0; i < positions_glass.size(); ++i) {
                    pos = positions_glass.get(i);
                    tile2 = w.func_147438_o(pos.x, pos.y, pos.z);
                    if (tile2 != null && tile2 instanceof FabricatorTileEntSlave) {
                        FabricatorTileEntSlave slave = (FabricatorTileEntSlave)tile2;
                        slave.updateMaster(masterPos.x, masterPos.y, masterPos.z);
                        slave.setType((byte)0);
                        slave.needBlockUpdate();
                        slave.needUpdate();
                        continue;
                    }
                    System.out.println("TileEnt null or wrong type, this should not happen!");
                }
                master.setComplete(true, (byte)direction);
                master.needBlockUpdate();
                master.needUpdate();
                return true;
            }
        }
        return false;
    }

    public IVariationInfo getManager(IBlockAccess world, int x, int y, int z, int metadata) {
        int meta = metadata;
        if (metadata <= MAX_META) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof MultiBlockSlaveTileEntBase) {
                if (((MultiBlockSlaveTileEntBase)tile).hasMaster()) {
                    meta = META_INVISIBLE;
                }
            } else if (tile instanceof MultiBlockMasterTileEntBase && ((MultiBlockMasterTileEntBase)tile).isComplete()) {
                meta = META_INVISIBLE;
            }
        }
        return this.carverHelper.getVariation(meta);
    }

    public IVariationInfo getManager(int meta) {
        return this.carverHelper.getVariation(meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.carverHelper.getIcon(side, meta);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata;
        int meta = metadata = world.func_72805_g(x, y, z);
        if (metadata <= MAX_META) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof MultiBlockSlaveTileEntBase) {
                if (((MultiBlockSlaveTileEntBase)tile).hasMaster()) {
                    meta = META_INVISIBLE;
                }
            } else if (tile instanceof MultiBlockMasterTileEntBase && ((MultiBlockMasterTileEntBase)tile).isComplete()) {
                meta = META_INVISIBLE;
            }
        }
        return this.carverHelper.getIcon(side, meta);
    }
}

