/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.GenericItemBlockMetadataStringPrefix;
import techguns.blocks.OreCluster;
import techguns.util.BlockCoords;
import techguns.util.TextUtil;

public class ItemBlockOreDrill
extends GenericItemBlockMetadataStringPrefix {
    public ItemBlockOreDrill(Block block) {
        super(block);
    }

    public static boolean isOreCluster(World w, int x, int y, int z) {
        return ItemBlockOreDrill.isBlock(w, x, y, z, TGBlocks.oreCluster, -1) || ItemBlockOreDrill.isBlock(w, x, y, z, TGBlocks.oreCluster2, -1);
    }

    public static boolean isBlock(World w, int x, int y, int z, Block block, int meta) {
        Block b = w.func_147439_a(x, y, z);
        if (Block.func_149682_b((Block)b) == Block.func_149682_b((Block)block)) {
            if (meta != -1) {
                int m = w.func_72805_g(x, y, z);
                boolean valid = m == meta;
                return valid;
            }
            return true;
        }
        return false;
    }

    public static int[] checkForBlockInNeighbourhood(World w, int x, int y, int z, Block b, int m) {
        int[] ret = new int[]{0, 0, 0};
        if (ItemBlockOreDrill.isBlock(w, x, y + 1, z, b, m)) {
            ret[1] = 1;
        } else if (ItemBlockOreDrill.isBlock(w, x, y - 1, z, b, m)) {
            ret[1] = -1;
        } else if (ItemBlockOreDrill.isBlock(w, x, y, z - 1, b, m)) {
            ret[2] = -1;
        } else if (ItemBlockOreDrill.isBlock(w, x + 1, y, z, b, m)) {
            ret[0] = 1;
        } else if (ItemBlockOreDrill.isBlock(w, x, y, z + 1, b, m)) {
            ret[2] = 1;
        } else if (ItemBlockOreDrill.isBlock(w, x - 1, y, z, b, m)) {
            ret[0] = -1;
        } else {
            return null;
        }
        return ret;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int ROD_META = 2;
        int CONTROLLER_META = 4;
        if (metadata == ROD_META) {
            OreCluster clust;
            int[] offset = null;
            Iterator<OreCluster> iterator = TGBlocks.oreclusters.iterator();
            while (iterator.hasNext() && (offset = ItemBlockOreDrill.checkForBlockInNeighbourhood(world, x, y, z, clust = iterator.next(), -1)) == null) {
            }
            if (offset != null) {
                int meta;
                Block cluster = world.func_147439_a(x + offset[0], y + offset[1], z + offset[2]);
                if (this.getHasConnectedDrillRod(world, x + offset[0], y + offset[1], z + offset[2], new ArrayList<BlockCoords>(), cluster, meta = world.func_72805_g(x + offset[0], y + offset[1], z + offset[2]), (Block)TGBlocks.oreDrill, ROD_META)) {
                    if (world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(TextUtil.trans("techguns.msg.error.alreadyrod")));
                    }
                    return false;
                }
                return super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
            }
            if (ItemBlockOreDrill.checkForBlockInNeighbourhood(world, x, y, z, (Block)TGBlocks.oreDrill, ROD_META) != null) {
                return super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
            }
            return false;
        }
        if (metadata == CONTROLLER_META) {
            if (ItemBlockOreDrill.checkForBlockInNeighbourhood(world, x, y, z, (Block)TGBlocks.oreDrill, CONTROLLER_META) != null) {
                if (world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"msg.error.oredrill.controllernext", (Object[])new Object[0])));
                }
                return false;
            }
            return super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        }
        return super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
    }

    public boolean getHasConnectedDrillRod(World world, int x, int y, int z, ArrayList<BlockCoords> visited, Block clusterType, int clusterMeta, Block DrillRodBlock, int meta) {
        Block target = world.func_147439_a(x, y, z);
        int targetMeta = world.func_72805_g(x, y, z);
        BlockCoords block = new BlockCoords(x, y, z);
        if (!visited.contains(block)) {
            if (target == clusterType && targetMeta == clusterMeta) {
                visited.add(block);
                boolean b1 = this.getHasConnectedDrillRod(world, x + 1, y, z, visited, clusterType, clusterMeta, DrillRodBlock, meta);
                boolean b2 = this.getHasConnectedDrillRod(world, x - 1, y, z, visited, clusterType, clusterMeta, DrillRodBlock, meta);
                boolean b3 = this.getHasConnectedDrillRod(world, x, y + 1, z, visited, clusterType, clusterMeta, DrillRodBlock, meta);
                boolean b4 = this.getHasConnectedDrillRod(world, x, y - 1, z, visited, clusterType, clusterMeta, DrillRodBlock, meta);
                boolean b5 = this.getHasConnectedDrillRod(world, x, y, z + 1, visited, clusterType, clusterMeta, DrillRodBlock, meta);
                boolean b6 = this.getHasConnectedDrillRod(world, x, y, z - 1, visited, clusterType, clusterMeta, DrillRodBlock, meta);
                return b1 || b2 || b3 || b4 || b5 || b6;
            }
            return target == DrillRodBlock && targetMeta == meta;
        }
        return false;
    }
}

