/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import techguns.blocks.GenericBlock;

public class GenericBlockMetadata
extends GenericBlock {
    protected String[] blocktextures;
    protected IIcon[] icons;
    protected int amountUsed;
    protected byte[] lightlevel;

    public GenericBlockMetadata(Material mat, int amountUsed) {
        super(mat);
        this.icons = new IIcon[amountUsed];
        this.blocktextures = new String[amountUsed];
        this.amountUsed = amountUsed;
        this.lightlevel = new byte[amountUsed];
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < this.amountUsed) {
            return this.icons[meta];
        }
        return super.func_149691_a(side, meta);
    }

    public void func_149651_a(IIconRegister r) {
        super.func_149651_a(r);
        for (int i = 0; i < this.amountUsed; ++i) {
            this.icons[i] = r.func_94245_a(this.blocktextures[i]);
        }
    }

    public void setBlockTypeForMeta(int meta, String tex) {
        this.blocktextures[meta] = tex;
        this.lightlevel[meta] = 0;
    }

    public void setLightLevelForMeta(int meta, int lightlevel) {
        this.lightlevel[meta] = (byte)lightlevel;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.amountUsed; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149692_a(int i) {
        return i;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < this.amountUsed) {
            return this.lightlevel[meta];
        }
        return super.getLightValue(world, x, y, z);
    }
}

