/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.blocks;

import com.piepenguin.rfwindmill.lib.Lang;
import com.piepenguin.rfwindmill.lib.Util;
import com.piepenguin.rfwindmill.tileentities.TileEntityWindmillBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class WindmillBlock
extends Block
implements ITileEntityProvider {
    protected final int maximumEnergyGeneration;
    protected final int maximumEnergyTransfer;
    protected final int capacity;
    private String name;
    private IIcon[] icons = new IIcon[6];

    public WindmillBlock(String pName, int pMaximumEnergyGeneration, int pCapacity) {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149672_a(Block.field_149777_j);
        this.maximumEnergyGeneration = pMaximumEnergyGeneration;
        this.maximumEnergyTransfer = pMaximumEnergyGeneration * 8;
        this.capacity = pCapacity;
        this.name = pName;
        this.func_149663_c("rfwindmill_" + this.name);
        this.func_149647_a(CreativeTabs.field_78030_b);
        GameRegistry.registerBlock((Block)this, (String)this.name);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icons[0] = iconRegister.func_94245_a("rfwindmill:" + this.name + "Side");
        this.icons[1] = iconRegister.func_94245_a("rfwindmill:" + this.name + "Side");
        this.icons[2] = iconRegister.func_94245_a("rfwindmill:" + this.name + "Front");
        this.icons[3] = iconRegister.func_94245_a("rfwindmill:" + this.name + "Front");
        this.icons[4] = iconRegister.func_94245_a("rfwindmill:" + this.name + "Side");
        this.icons[5] = iconRegister.func_94245_a("rfwindmill:" + this.name + "Side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.icons[0];
            }
            case 1: {
                return this.icons[1];
            }
            case 2: {
                return this.icons[meta == 0 || meta == 2 ? 2 : 4];
            }
            case 3: {
                return this.icons[meta == 0 || meta == 2 ? 2 : 4];
            }
            case 4: {
                return this.icons[meta == 1 || meta == 3 ? 2 : 4];
            }
            case 5: {
                return this.icons[meta == 1 || meta == 3 ? 2 : 4];
            }
        }
        return this.icons[0];
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWindmillBlock(this.maximumEnergyGeneration, this.maximumEnergyTransfer, this.capacity);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        int direction = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, direction, 2);
        if (itemStack.field_77990_d != null) {
            TileEntityWindmillBlock entity = (TileEntityWindmillBlock)world.func_147438_o(x, y, z);
            entity.setEnergyStored(itemStack.field_77990_d.func_74762_e("ESEnergy"));
        }
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float dx, float dy, float dz) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                if (Util.hasWrench(player, x, y, z)) {
                    this.dismantle(world, x, y, z);
                    return true;
                }
                this.printChatInfo(world, x, y, z, player);
                return true;
            }
            if (Util.hasWrench(player, x, y, z)) {
                int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                world.func_72921_c(x, y, z, direction, 2);
            }
        }
        return false;
    }

    public void func_149681_a(World pWorld, int pX, int pY, int pZ, int pSide, EntityPlayer pPlayer) {
        if (!pWorld.field_72995_K) {
            this.dismantle(pWorld, pX, pY, pZ);
        }
    }

    private void dismantle(World pWorld, int pX, int pY, int pZ) {
        ItemStack itemStack = new ItemStack((Block)this);
        TileEntityWindmillBlock entity = (TileEntityWindmillBlock)pWorld.func_147438_o(pX, pY, pZ);
        int energy = entity.getEnergyStored();
        if (energy > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("ESEnergy", energy);
        }
        pWorld.func_147468_f(pX, pY, pZ);
        EntityItem entityItem = new EntityItem(pWorld, (double)pX + 0.5, (double)pY + 0.5, (double)pZ + 0.5, itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        pWorld.func_72838_d((Entity)entityItem);
    }

    private void printChatInfo(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityWindmillBlock entity = (TileEntityWindmillBlock)world.func_147438_o(x, y, z);
        String msg = String.format("%s: %d/%d RF", Lang.localise("energy.stored"), entity.getEnergyStored(), entity.getMaxEnergyStored());
        player.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }
}

